<?php
/* Copyright (C) 2004-2017 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2020 SuperAdmin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * \file    takeposconnectorplus/admin/setup.php
 * \ingroup takeposconnectorplus
 * \brief   TakeposConnectorPlus setup page.
 */

// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) $res = @include $_SERVER["CONTEXT_DOCUMENT_ROOT"]."/main.inc.php";
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME']; $tmp2 = realpath(__FILE__); $i = strlen($tmp) - 1; $j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) { $i--; $j--; }
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1))."/main.inc.php")) $res = @include substr($tmp, 0, ($i + 1))."/main.inc.php";
if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1)))."/main.inc.php")) $res = @include dirname(substr($tmp, 0, ($i + 1)))."/main.inc.php";
// Try main.inc.php using relative path
if (!$res && file_exists("../../main.inc.php")) $res = @include "../../main.inc.php";
if (!$res && file_exists("../../../main.inc.php")) $res = @include "../../../main.inc.php";
if (!$res) die("Include of main fails");

global $langs, $user;

// Libraries
require_once DOL_DOCUMENT_ROOT."/core/lib/admin.lib.php";
require_once '../lib/takeposconnectorplus.lib.php';
//require_once "../class/myclass.class.php";

// Translations
$langs->loadLangs(array("admin", "cashdesk", "takeposconnectorplus@takeposconnectorplus"));

// Access control
if (!$user->admin) accessforbidden();

// Parameters
$action = GETPOST('action', 'alpha');
$backtopage = GETPOST('backtopage', 'alpha');

$arrayofparameters = array(
	'TAKEPOSCONNECTORPLUS_MYPARAM1'=>array('css'=>'minwidth200', 'enabled'=>1),
	'TAKEPOSCONNECTORPLUS_MYPARAM2'=>array('css'=>'minwidth500', 'enabled'=>1)
);



/*
 * Actions
 */

if ((float) DOL_VERSION >= 6)
{
	include DOL_DOCUMENT_ROOT.'/core/actions_setmoduleoptions.inc.php';
}

if (GETPOST('action', 'alpha') == 'set')
{
	$res = dolibarr_set_const($db, "TAKEPOS_CONNECTOR_PRINTER_1", GETPOST('TAKEPOS_CONNECTOR_PRINTER_1', 'alpha'), 'chaine', 0, '', $conf->entity);
    $res = dolibarr_set_const($db, "TAKEPOS_TEMPLATE_TO_USE_FOR_INVOICES", GETPOST('TAKEPOS_TEMPLATE_TO_USE_FOR_INVOICES', 'alpha'), 'chaine', 0, '', $conf->entity);
    $res = dolibarr_set_const($db, "TAKEPOS_TEMPLATE_TO_USE_FOR_ORDERS", GETPOST('TAKEPOS_TEMPLATE_TO_USE_FOR_ORDERS', 'alpha'), 'chaine', 0, '', $conf->entity);
}



/*
 * View
 */

$page_name = "Takepos Connector PLUS Setup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="'.($backtopage ? $backtopage : DOL_URL_ROOT.'/admin/modules.php?restore_lastsearch_values=1').'">'.$langs->trans("BackToModuleList").'</a>';

print load_fiche_titre($langs->trans($page_name), $linkback, 'object_takeposconnectorplus@takeposconnectorplus');

// Configuration header
$head = takeposconnectorplusAdminPrepareHead();
dol_fiche_head($head, 'settings', '', -1, "takeposconnectorplus@takeposconnectorplus");

// Setup page goes here
echo '<span class="opacitymedium">'.$langs->trans("TakeposConnectorPlusSetupPage").'</span><br><br>';



	print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
	print '<input type="hidden" name="token" value="'.newToken().'">';
	print '<input type="hidden" name="action" value="set">';

	print '<table class="noborder centpercent">';
	print '<tr class="liste_titre"><td class="titlefield">'.$langs->trans("Parameter").'</td><td>'.$langs->trans("Value").'</td></tr>';

	require_once DOL_DOCUMENT_ROOT.'/core/class/dolreceiptprinter.class.php';
	$printer = new dolReceiptPrinter($db);
	$printer->listprinters();
	$printers = array();
	foreach ($printer->listprinters as $key => $value) {
		$printers[$value['rowid']] = $value['name'];
	}
	print '<tr class="oddeven"><td>'.$langs->trans("Printer").' 1</td>';
	print '<td>';
	print $form->selectarray('TAKEPOS_CONNECTOR_PRINTER_1', $printers, (empty($conf->global->TAKEPOS_CONNECTOR_PRINTER_1) ? '0' : $conf->global->TAKEPOS_CONNECTOR_PRINTER_1), 1);
	print '</td></tr>';
	$printer->listPrintersTemplates();
	$templates = array();
	foreach ($printer->listprinterstemplates as $key => $value) {
		$templates[$value['rowid']] = $value['name'];
	}
	print '<tr class="oddeven"><td>'.$langs->trans("TakeposTerminalTemplateToUseForInvoicesTicket").'</td>';
	print '<td>';
	print $form->selectarray('TAKEPOS_TEMPLATE_TO_USE_FOR_INVOICES', $templates, (empty($conf->global->TAKEPOS_TEMPLATE_TO_USE_FOR_INVOICES) ? '0' : $conf->global->TAKEPOS_TEMPLATE_TO_USE_FOR_INVOICES), 1);
	print '</td></tr>';
	print '<tr class="oddeven"><td>'.$langs->trans("TakeposTerminalTemplateToUseForOrdersTicket").'</td>';
	print '<td>';
	print $form->selectarray('TAKEPOS_TEMPLATE_TO_USE_FOR_ORDERS', $templates, (empty($conf->global->TAKEPOS_TEMPLATE_TO_USE_FOR_ORDERS) ? '0' : $conf->global->TAKEPOS_TEMPLATE_TO_USE_FOR_ORDERS), 1);
	print '</td></tr>';
	print '</table>';

	print '<br><div class="center">';
	print '<input class="button" type="submit" value="'.$langs->trans("Save").'">';
	print '</div>';

	print '</form>';
	print '<br>';


// Page end
dol_fiche_end();

llxFooter();
$db->close();
